/*
 *	$Source: /u1/Xr/usr/contrib/RB/RCS/image.h,v $
 *	$Header: image.h,v 1.1 86/12/17 08:54:40 swick Exp $
 */

/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        image.h
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: This file contains the defines, strucutures, and data
 **                necessary for image.c of the icon builder.
 **
 **   *******************************************************************
 **   * (c)  Copyright Hewlett-Packard Company, 1986.  All rights are   *
 **   * reserved.  Copying or other reproduction of this program except *
 **   * for archival purposes is prohibited without the prior written   *
 **   * consent of Hewlett-Packard Company.                             *
 **   *******************************************************************
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	image.h,v $
 * Revision 1.1  86/12/17  08:54:40  swick
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/

extern ImageEdit();



static xrTitleBarInfo titleBarInfo =
{
   0,				/* windowId         */
   {0, 0, 0, 0},		/* editor rectangle */
   0,				/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Raster Image",		/* title name	    */
   NULL,			/* gadget 1	    */
   NULL				/* gadget 2	    */
};


static xrScrollBarInfo scrollHorInfo =
{
   0,				/* windowId */
   {0, 0, 0, 11},		/* editor rectangle */
   0,				/* editor state     */
   -1, -1,			/* editor colors    */
   XrHORIZONTAL,		/* orientation      */
 {
   XrSCROLLARROWS | XrSLIDEBOX,	/* components       */
   0, 100,			/* min, max         */
   0,				/* slide position   */
   10,				/* slide size       */
   NULL,			/* scroll handler   */
   1,				/* granularity	    */
 }
};


static xrScrollBarInfo scrollVertInfo =
{
   0,				/* windowId */
   {0, 0, 11, 0},		/* editor rectangle */
   0,				/* editor state     */
   -1, -1,			/* editor colors    */
   XrVERTICAL,			/* orientation      */
 {
   XrSCROLLARROWS | XrSLIDEBOX,	/* components       */
   0, 100,			/* min, max         */
   0,				/* slide position   */
   10,				/* slide size       */
   NULL,			/* scroll handler   */
   1,				/* granularity	    */
 }
};



static Window     mainWindowId;	/*  The image display window  */
static Window     subWindowId;	/*  The image display window  */

static INT32      mainWindowX;
static INT32      mainWindowY;
static INT32      mainWindowWidth;
static INT32      mainWindowHeight;
static INT32      subWindowX;
static INT32      subWindowY;
static INT32      subWindowWidth;
static INT32      subWindowHeight;

static xrEditor * titleBar;	/*  The titlebar instance     */
static xrEditor * scrollHor;	/*  The scrollbar instance    */
static xrEditor * scrollVert;	/*  The scrollbar instance    */

static xrWindowData windowData; /*  Registered window data    */

static xrPixmap * pixmap;
static INT32 pixmapMapX;
static INT32 pixmapMapY;

static INT8 horScrollable;
static INT8 vertScrollable;

static INT32 maxWindowWidth = 400;
static INT32 maxWindowHeight = 400;


static xrWindowEvent eventSet[] =
   { ExposeWindow | EnterWindow, 0 };


static xrWindowFunctInfo windowFunct;

