/*
 *	$Source: /u1/Xr/usr/contrib/RB/RCS/convert.c,v $
 *	$Header: convert.c,v 1.1 86/12/17 08:52:57 swick Exp $
 */

#ifndef lint
static char *rcsid_convert_c = "$Header: convert.c,v 1.1 86/12/17 08:52:57 swick Exp $";
#endif	lint

/************************************************************************
 *
 *   Convert
 *	This program reads and converts a binary raster file
 *      created by the raster builder into a .h include file.
 *
 ************************************************************************/


#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>

main (argc, argv)
int argc;
char * argv[];

{
   register INT32 count, i;
   register INT32 fd;
   INT16 height, width, csum;
   UINT8 depth;
   UINT8 rasterByte;

   if ((fd = open (argv[1], 0666)) == -1)
      return (FALSE);

   ValueRead (fd, (char *) &height);
   ValueRead (fd, (char *) &width);
   read (fd, (char *) &depth, 1);
   ValueRead (fd, (char *) &csum);

   if (depth == XrBIT1)
      count = BitmapSize (width, height);
   else if (depth <= XrBYTE1)
      count = BZPixmapSize (width, height);
   else
      count = WZPixmapSize (width, height);

   printf ("UINT16 %sRaster[] =\n{\n", argv[2]);
   printf ("   ");
   i = 0;
   while (i < count)
   {
      read (fd, (char *) &rasterByte, 1);
      if (rasterByte < 16)
         printf ("0x0%1x", rasterByte);
      else
         printf ("0x%2x", rasterByte);

      read (fd, (char *) &rasterByte, 1);
      if (rasterByte < 16)
         printf ("0%1x, ", rasterByte);
      else
         printf ("%2x, ", rasterByte);

      i += 2;
      if (i % 8 == 0)
         printf ("\n   ");
   }
   printf ("\n};\n\n\n");

   printf ("xrPixmap %s = \n{\n", argv[2]);
   printf ("   %d,			/*  raster width       */\n",
           width);
   printf ("   %d,			/*  raster height      */\n",
           height);
   printf ("   %d,			/*  raster depth       */\n",
           depth);
   printf ("   %sRaster		/*  ptr to the raster  */\n};\n\n",
           argv[2]);
   close (fd);
}



ValueRead (fd, value)
INT32   fd;
INT16 * value;

{
   INT8 string [4];

   read (fd, string, 4);
   *value = atoi (string);
}

