/*
 *	$Source: /u1/Xr/usr/contrib/RB/RCS/buildPanel.h,v $
 *	$Header: buildPanel.h,v 1.1 86/12/17 08:54:16 swick Exp $
 */

/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        buildPanel.h
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: This file contains the defines, strucutures, and data
 **                necessary for buildPanel.c of the icon builder.
 **
 **   *******************************************************************
 **   * (c)  Copyright Hewlett-Packard Company, 1986.  All rights are   *
 **   * reserved.  Copying or other reproduction of this program except *
 **   * for archival purposes is prohibited without the prior written   *
 **   * consent of Hewlett-Packard Company.                             *
 **   *******************************************************************
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	buildPanel.h,v $
 * Revision 1.1  86/12/17  08:54:16  swick
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/

static xrTitleBarInfo panelTBInfo =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Builder Settings",		/* title name	    */
   NULL,			/* gadget 1	    */
   NULL				/* gadget 2	    */
};


static xrStaticTextInfo panelSTInfo1 =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE,			/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Editor View Size:",		/* string	    */
   XrNO_ALIGNMENT		/* alignment        */
};

static xrStaticTextInfo panelSTInfo2 =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE,			/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Editor Bit Size:",		/* string	    */
   XrNO_ALIGNMENT		/* alignment        */
};


static xrStaticTextInfo panelSTInfo3 =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE,			/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Raster Size:",		/* string	    */
   XrNO_ALIGNMENT		/* alignment        */
};

static xrStaticTextInfo panelSTInfo4 =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE,			/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Raster Depth:",		/* string	    */
   XrNO_ALIGNMENT		/* alignment        */
};


static INT8 * panelRLabels[] =
{
   "Bitmap",
   "Pixmap",
};

INT16 panelRValue = 0;

static xrRadioButtonInfo panelRBInfo =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   2,				/* num of fields    */
   1,				/* num of cols      */
   panelRLabels,		/* label array	    */
   &panelRValue,		/* values           */
   NULL				/* state flags      */
};



static INT8 *panelPLabels[] =
{
   "Defaults",
   "Close Panel"
};

static xrPushButtonInfo panelPBInfo =
{
   0,				/* windowId */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   2, 1,			/* field, col count */
   -1,				/* default button   */
   2,				/* border width     */
   panelPLabels,		/* labels           */
   NULL				/* flags            */
};



static INT8 panelTEString1[4] = "24";

static xrTextEditInfo panelTEInfo1 =
{
   0,				/* windowId         */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Wide",			/* editor label     */
   panelTEString1,		/* editor string    */
   3,				/* max chars        */
   0,				/* insert pos       */
   XrINTERACTIVE,		/* insert mode      */
   XrRIGHT_ALIGNED,		/* label position   */
   0
};


static INT8 panelTEString2[4] = "24";

static xrTextEditInfo panelTEInfo2 =
{
   0,				/* windowId         */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "High",			/* editor label     */
   panelTEString2,		/* editor string    */
   3,				/* max chars        */
   0,				/* insert pos       */
   XrINTERACTIVE,		/* insert mode      */
   XrRIGHT_ALIGNED,		/* label position   */
   0
};


static INT8 panelTEString3[4] = "8";

static xrTextEditInfo panelTEInfo3 =
{
   0,				/* windowId         */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Pixels",			/* editor label     */
   panelTEString3,		/* editor string    */
   2,				/* max chars        */
   0,				/* insert pos       */
   XrINTERACTIVE,		/* insert mode      */
   XrRIGHT_ALIGNED,		/* label position   */
   0
};


static INT8 panelTEString4[4] = "64";

static xrTextEditInfo panelTEInfo4 =
{
   0,				/* windowId         */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "Wide",			/* editor label     */
   panelTEString4,		/* editor string    */
   3,				/* max chars        */
   0,				/* insert pos       */
   XrINTERACTIVE,		/* insert mode      */
   XrRIGHT_ALIGNED,		/* label position   */
   0,
};


static INT8 panelTEString5[4] = "64";

static xrTextEditInfo panelTEInfo5 =
{
   0,				/* windowId         */
   {0, 0, 0, 0},		/* editor rectangle */
   XrVISIBLE | XrSENSITIVE,	/* editor state     */
   -1, -1,			/* editor colors    */
   NULL,			/* editor font      */
   "High",			/* editor label     */
   panelTEString5,		/* editor string    */
   3,				/* max chars        */
   0,				/* insert pos       */
   XrINTERACTIVE,		/* insert mode      */
   XrRIGHT_ALIGNED,		/* label position   */
   0,
};


static xrPanelField panelFields[] =
{
   {  XrTitleBar,    (INT8 *) &panelTBInfo,  NULL  },
   {  XrStaticText,  (INT8 *) &panelSTInfo1, NULL  },
   {  XrStaticText,  (INT8 *) &panelSTInfo2, NULL  },
   {  XrStaticText,  (INT8 *) &panelSTInfo3, NULL  },
   {  XrStaticText,  (INT8 *) &panelSTInfo4, NULL  },
   {  XrRadioButton, (INT8 *) &panelRBInfo,  NULL  },
   {  XrPushButton,  (INT8 *) &panelPBInfo,  NULL  },
   {  XrTextEdit,    (INT8 *) &panelTEInfo1, NULL  },
   {  XrTextEdit,    (INT8 *) &panelTEInfo2, NULL  },
   {  XrTextEdit,    (INT8 *) &panelTEInfo3, NULL  },
   {  XrTextEdit,    (INT8 *) &panelTEInfo4, NULL  },
   {  XrTextEdit,    (INT8 *) &panelTEInfo5, NULL  }
};



static xrPanelInfo panelInfo =
{
   {30, 30},		/* panel origin      */
   {0, 0},
   0,			/* relative to       */
   0,                   /* child of          */
   NULL,		/* panel context     */
   panelFields,		/* panel editor list */
   12,			/* editor count      */
   0,			/* panel id	     */
};

static xrPanel * panel;

static xrPanelContext panelContext;

extern xrRasterEditInfo rasterEditInfo;
