/*
 *	$Source: /u1/Xr/src/Xrlib/Editor/RCS/rectUtil.c,v $
 *	$Header: rectUtil.c,v 1.1 86/12/17 09:07:15 swick Exp $
 */

#ifndef lint
static char *rcsid_rectUtil_c = "$Header: rectUtil.c,v 1.1 86/12/17 09:07:15 swick Exp $";
#endif	lint


#include <Xr/xr-copyright.h>

/* $Header: rectUtil.c,v 1.1 86/12/17 09:07:15 swick Exp $ */
/* Copyright 1986, Hewlett-Packard Company */
/* Copyright 1986, Massachussetts Institute of Technology */

static char rcsid[] = "$Header: rectUtil.c,v 1.1 86/12/17 09:07:15 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        rectUtil.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: 
 **         This file contains several utility routines which may be
 **         used by field editors to draw lines, rectangle outlines,
 **         and filled rectangles.  As with all of the other field
 **         editor drawing routines, these use the graphics context
 **         structure to obtain all of the drawing environment 
 **         information.
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	rectUtil.c,v $
 * Revision 1.1  86/12/17  09:07:15  swick
 * Initial revision
 * 
 * Revision 7.0  86/11/13  08:31:02  08:31:02  fred ()
 * Final QA Release
 * 
 * Revision 6.0  86/11/10  15:39:40  15:39:40  fred ()
 * QA #2 release
 * 
 * Revision 5.1  86/11/07  14:27:28  14:27:28  fred ()
 * Added new copyright message.
 * 
 * Revision 5.0  86/10/28  08:41:43  08:41:43  fred ()
 * QA #1.1 release
 * 
 * Revision 4.0  86/10/20  12:17:18  12:17:18  fred ()
 * QA #1 release
 * 
 * Revision 3.1  86/10/16  09:24:54  09:24:54  fred ()
 * Performance enhanced: added use of register variables.
 * 
 * Revision 3.0  86/10/02  16:08:24  16:08:24  fred ()
 * Alpha release set to 3.0
 * 
 * Revision 2.2  86/09/18  09:36:52  09:36:52  fred ()
 * Fixed _XrBorderFillRectangle() so that the interior is correctly filled.
 * 
 * Revision 2.1  86/09/17  06:28:28  06:28:28  fred ()
 * Filled in the procedure headers.
 * 
 * Revision 2.0  86/09/16  08:17:38  08:17:38  fred ()
 * No change; upgraded to revision 2.0 to match other source.
 * 
 * Revision 1.1  86/09/03  14:01:00  14:01:00  fred ()
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/



#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>


static Vertex rectList [5] =
   { {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0} };




/*************************************<->*************************************
 *
 *  _XrLine (windowId, GC, x1, y1, x2, y2)
 *
 *     Window windowId;
 *     INT32  GC;
 *     INT16  x1, y1, x2, y2;
 *
 *   Description:
 *   -----------
 *     This routine will draw a line from the point specified by (x1, y1)
 *     to the point specified by (x2, y2), using the line width, pen color
 *     and replacement rule specified in the indicated graphics context.
 *
 *
 *   Inputs:
 *   ------
 *     windowId = Window Id for the window in which the line is to be drawn.
 *
 *     GC = The index of the graphics context which contains the drawing
 *          environment.  The field of interest in the graphic context are:
 *
 *          XrLINEWIDTHVAL  = The width of the line to draw.
 *          XrFOREGROUNDVAL = The pen color to draw the line with.
 *          XrALUVAL        = The replacement rule; refer to X documentation.
 *
 *     x1, y1 = The coordinates for the starting point of the line.
 *
 *     x2, y2 = The coordinates for the ending point of the line.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XLine()  [libX.a]
 *
 *************************************<->***********************************/

_XrLine (windowId, GC, x1, y1, x2, y2)

   Window windowId;
   INT32  GC;
   INT16  x1;
   INT16  y1;
   INT16  x2;
   INT16  y2;

{
   XLine (windowId, x1, y1, x2, y2, 
          xr_GCList[GC][XrLINEWIDTHVAL], xr_GCList[GC][XrLINEWIDTHVAL],
          xr_GCList[GC][XrFOREGROUNDVAL], xr_GCList[GC][XrALUVAL], AllPlanes);
}

/*************************************<->*************************************
 *
 *  _XrRectangle (windowId, GC, drawRect)
 *
 *     Window      windowId;
 *     INT32       GC;
 *     RECTANGLE * drawRect;
 *
 *   Description:
 *   -----------
 *     This routine will draw the outline of the rectangle whose
 *     definition is pointed to by the 'drawRect' parameter.  The
 *     interior of the rectangle is left unchanged.  The line width,
 *     pen color and replacement rule are obtained from the specified
 *     graphics context.
 *
 *
 *   Inputs:
 *   ------
 *     windowId = The window Id of the window in which the rectangle
 *                is to be drawn.
 *
 *     GC = This is the index of the graphics context which contains
 *          the drawing environment.  The field of interest are:
 *
 *          XrLINEWIDTHVAL  = Width of the line used to draw the rectangle.
 *          XrFOREGROUNDVAL = The pen color to draw the rectangle with.
 *          XrALUVAL        = The X replacement rule.
 *
 *     drawRect = This points to the rectangle definition.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XDraw()  [libX.a]
 *
 *************************************<->***********************************/

_XrRectangle (windowId, GC, drawRect)

            Window      windowId;
   register INT32       GC;
   register RECTANGLE * drawRect;

{

   rectList[0].x = drawRect->x;
   rectList[0].y = drawRect->y;
   rectList[1].x = drawRect->x + drawRect->width - 1;
   rectList[1].y = drawRect->y;
   rectList[2].x = drawRect->x + drawRect->width - 1;
   rectList[2].y = drawRect->y + drawRect->height - 1;
   rectList[3].x = drawRect->x;
   rectList[3].y = drawRect->y + drawRect->height - 1;
   rectList[4].x = drawRect->x;
   rectList[4].y = drawRect->y;

   XDraw (windowId, rectList, 5, 
          xr_GCList[GC][XrLINEWIDTHVAL], xr_GCList[GC][XrLINEWIDTHVAL],
          xr_GCList[GC][XrFOREGROUNDVAL], xr_GCList[GC][XrALUVAL], AllPlanes);
}


/*************************************<->*************************************
 *
 *  _XrFillRectangle (windowId, GC, drawRect)
 *
 *     Window      windowId;
 *     INT32       GC;
 *     RECTANGLE * drawRect;
 *
 *   Description:
 *   -----------
 *     This routine fills the rectangular region described by the
 *     'drawRect' parameter, using either a solid or tile filled style.
 *     A surrounding border is not drawn.  The fill style, pen color
 *     and tile id are obtained from the specified graphics context
 *
 *
 *   Inputs:
 *   ------
 *     windowId = Id of the window in which the rectangle is to be drawn.
 *
 *     GC = This is the index of the graphics context which contains
 *          the drawing environment.  The field of interest are:
 *
 *          XrFILLSTYLEVAL  = Type of filling to use: Solid or Tiled.
 *          XrFOREGROUNDVAL = The fill color, if using solid fill.
 *          XrTILEVAL       = The tile Id, if using tile fill.
 *
 *     drawRect = This points to the rectangle definition.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XPixSet()   [libX.a]
 *   XTileSet()  [libX.a]
 *
 *************************************<->***********************************/

_XrFillRectangle (windowId, GC, drawRect)

   Window      windowId;
   INT32       GC;
   RECTANGLE * drawRect;

{
   if (xr_GCList[GC][XrFILLSTYLEVAL] == Solid)
      XPixSet (windowId, drawRect -> x, drawRect -> y, drawRect -> width,
               drawRect -> height, xr_GCList[GC][XrFOREGROUNDVAL]);

   else if (xr_GCList[GC][XrFILLSTYLEVAL] == Tiled)
      XTileSet (windowId, drawRect -> x, drawRect -> y, drawRect -> width,
                drawRect -> height, xr_GCList[GC][XrTILEVAL]);
}

/*************************************<->*************************************
 *
 *  _XrBorderFillRectangle (windowId, borderGC, fillGC, drawRect)
 *
 *     Window      windowId;
 *     INT32       borderGC;
 *     INT32       fillGC;
 *     RECTANGLE * drawRect;
 *
 *   Description:
 *   -----------
 *     This routine draw the outline of the specified rectangle, using
 *     the drawing environment contained in the border graphics context,
 *     and then fills the interior of the rectangle, using the drawing
 *     environment contained in the fill graphics context.  The border
 *     width, pen colors, fill style and tile Id are specified by the
 *     field editor invoking this routine.  The drawing is done by first
 *     drawing the border, then insetting the rectangle by the border
 *     width, and lastly filling this new inset rectangle.
 *
 *
 *   Inputs:
 *   ------
 *     windowId = The window Id of the window in which the rectangle
 *                is to be drawn.
 *
 *     borderGC = This is the index of the graphics context which contains
 *                the drawing environment used when drawing the border.  
 *                The field of interest are:
 *
 *                XrLINEWIDTHVAL  = Width of rectangle border line.
 *                XrFOREGROUNDVAL = The pen color to use.
 *                XrALUVAL        = The X replacement rule.
 *
 *     fillGC = This is the index of the graphics context which contains
 *              the drawing environment used when filling the rectangle.  
 *              The field of interest are:
 *
 *              XrFILLSTYLEVAL  = Type of filling to use: Solid or Tiled.
 *              XrFOREGROUNDVAL = The fill color, if using solid fill.
 *              XrTILEVAL       = The tile Id, if using tile fill.
 *
 *     drawRect = This points to the rectangle definition.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   _XrRectangle()
 *   _XrFillRectangle()
 *   XrCopyRect()        [calc.c]
 *   XrInsetRect()       [calc.c]
 *
 *************************************<->***********************************/

_XrBorderFillRectangle (windowId, borderGC, fillGC, drawRect)

            Window      windowId;
   register INT32       borderGC;
            INT32       fillGC;
            RECTANGLE * drawRect;

{
   RECTANGLE workRect;

   _XrRectangle (windowId, borderGC, drawRect);
   XrCopyRect (drawRect, &workRect);
   workRect.x += xr_GCList[borderGC][XrLINEWIDTHVAL];
   workRect.y += xr_GCList[borderGC][XrLINEWIDTHVAL];
   workRect.height -= (xr_GCList[borderGC][XrLINEWIDTHVAL] + 1);
   workRect.width -= (xr_GCList[borderGC][XrLINEWIDTHVAL] + 1);
   _XrFillRectangle (windowId, fillGC, &workRect);
}

