/*
 *	$Source: /u1/Xr/src/Xrlib/Editor/RCS/ovalUtil.c,v $
 *	$Header: ovalUtil.c,v 1.1 86/12/17 09:06:47 swick Exp $
 */

#ifndef lint
static char *rcsid_ovalUtil_c = "$Header: ovalUtil.c,v 1.1 86/12/17 09:06:47 swick Exp $";
#endif	lint


#include <Xr/xr-copyright.h>

/* $Header: ovalUtil.c,v 1.1 86/12/17 09:06:47 swick Exp $ */
/* Copyright 1986, Hewlett-Packard Company */
/* Copyright 1986, Massachussetts Institute of Technology */

static char rcsid[] = "$Header: ovalUtil.c,v 1.1 86/12/17 09:06:47 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        ovalUtil.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: 
 **         This file contains a series of drawing routines which may
 **         be useful to field editors.  They allow a field editor to
 **         draw either an outline of an oval, or a filled oval.  All
 **         of the drawing procedures provided here use a graphics
 **         context to obtain the drawing environment.
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	ovalUtil.c,v $
 * Revision 1.1  86/12/17  09:06:47  swick
 * Initial revision
 * 
 * Revision 7.0  86/11/13  15:42:33  15:42:33  fred ()
 * Final QA release
 * 
 * Revision 6.1  86/11/13  15:42:01  15:42:01  fred ()
 * >>     
 * Removed MVAX ifdef
 * 
 * Revision 6.0  86/11/10  15:39:01  15:39:01  fred ()
 * QA #2 release
 * 
 * Revision 5.1  86/11/07  14:26:39  14:26:39  fred ()
 * Added new copyright message.
 * 
 * Revision 5.0  86/10/28  08:40:41  08:40:41  fred ()
 * QA #1.1 release
 * 
 * Revision 4.0  86/10/20  12:16:28  12:16:28  fred ()
 * QA #1 release
 * 
 * Revision 3.1  86/10/16  09:24:08  09:24:08  fred ()
 * Performance enhanced: added use of register variables.
 * 
 * Revision 3.0  86/10/02  16:05:09  16:05:09  fred ()
 * Alpha release set to 3.0
 * 
 * Revision 2.2  86/09/25  13:26:09  13:26:09  fred ()
 * Added the compile ifdef MVAX, for drawing real ovals.
 * 
 * Revision 2.1  86/09/16  14:57:45  14:57:45  fred ()
 * Filled in procedure headers.
 * 
 * Revision 2.0  86/09/16  08:16:30  08:16:30  fred ()
 * No change; upgraded to revision 2.0 to match other source.
 * 
 * Revision 1.1  86/09/03  14:00:07  14:00:07  fred ()
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/



#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>


static Vertex ovalList [11] =
   { {0, 0, VertexStartClosed | VertexDontDraw | VertexCurved},
     {0, 0, 0},
     {0, 0, 0},
     {0, 0, VertexDontDraw | VertexCurved},
     {0, 0, VertexCurved},
     {0, 0, VertexCurved},
     {0, 0, VertexDontDraw | VertexCurved},
     {0, 0, 0},
     {0, 0, VertexDontDraw | VertexCurved},
     {0, 0, VertexCurved},
     {0, 0, VertexCurved | VertexEndClosed} };




/*************************************<->*************************************
 *
 *  _XrOval (windowId, GC, drawRect)
 *
 *     Window      windowId;
 *     INT32       GC;
 *     RECTANGLE * drawRect;
 *
 *   Description:
 *   -----------
 *     This routine will draw the outline of an oval.  The oval is
 *     defined such that it fits within the bounds of the rectangle
 *     defined by the 'drawRect' parameter.  The foreground color,
 *     line width, and replacement rule specified within the indicated
 *     graphics context will be used.
 *
 *
 *   Inputs:
 *   ------
 *     windowId = This is the window Id for the window in which the
 *                oval is to be drawn.
 *
 *     GC = This is the index of the graphics context which contains
 *          the drawing environment.  The fields of importance are:
 *
 *          XrLINEWIDTHVAL  = Width of the line used to draw the oval.
 *          XrFOREGROUNDVAL = Color to draw the oval with.
 *          XrALUVAL        = The replacement rule.
 *
 *     drawRect = This defines the rectangular region into which the
 *                oval is to be drawn.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XDraw()  [libX.a]
 *
 *************************************<->***********************************/

_XrOval (windowId, GC, drawRect)

            Window      windowId;
   register INT32       GC;
   register RECTANGLE * drawRect;

{
   register INT32 heightHalf;

   heightHalf = ((UINT16) drawRect->height >> 1);

   ovalList[0].x = drawRect->x + heightHalf;
   ovalList[0].y = drawRect->y;
   ovalList[1].x = drawRect->x + heightHalf;
   ovalList[1].y = drawRect->y;
   ovalList[2].x = drawRect->x + drawRect->width - heightHalf - 1;
   ovalList[2].y = drawRect->y;
   ovalList[3].x = drawRect->x + drawRect->width - heightHalf - 1;
   ovalList[3].y = drawRect->y;
   ovalList[4].x = drawRect->x + drawRect->width - 1;
   ovalList[4].y = drawRect->y + heightHalf;
   ovalList[5].x = drawRect->x + drawRect->width - heightHalf - 1;
   ovalList[5].y = drawRect->y + drawRect->height - 1;
   ovalList[6].x = drawRect->x + drawRect->width - heightHalf - 1;
   ovalList[6].y = drawRect->y + drawRect->height - 1;
   ovalList[7].x = drawRect->x + heightHalf;
   ovalList[7].y = drawRect->y + drawRect->height - 1;
   ovalList[8].x = drawRect->x + heightHalf;
   ovalList[8].y = drawRect->y + drawRect->height - 1;
   ovalList[9].x = drawRect->x;
   ovalList[9].y = drawRect->y + heightHalf;
   ovalList[10].x = drawRect->x + heightHalf;
   ovalList[10].y = drawRect->y;

   XDraw (windowId, ovalList, 11, 
          xr_GCList[GC][XrLINEWIDTHVAL], xr_GCList[GC][XrLINEWIDTHVAL],
          xr_GCList[GC][XrFOREGROUNDVAL], xr_GCList[GC][XrALUVAL], AllPlanes);
}


/*************************************<->*************************************
 *
 *  _XrFillOval (windowId, GC, drawRect)
 *
 *     Window      windowId;
 *     INT32       GC;
 *     RECTANGLE * drawRect;
 *
 *   Description:
 *   -----------
 *     This routine will draw a filled oval, using the drawing environment
 *     contained within the specified graphics context.  It is capable
 *     of using either Tiled or Solid filling.  The oval is drawn such
 *     that it fits completely within the rectangular region defined
 *     by the 'drawRect' parameter.
 *
 *
 *   Inputs:
 *   ------
 *     windowId = This is the window Id for the window in which the
 *                oval is to be drawn.
 *
 *     GC = This is the index of the graphics context which contains
 *          the drawing environment.  The fields of importance are:
 *
 *          XrFILLSTYLEVAL  = May be either Tiled or Solid.
 *          XrFOREGROUNDVAL = Color to use for a Solid filled oval.
 *          XrTILEVAL       = Tile to use for a Tile filled oval.
 *          XrALUVAL        = The replacement rule.
 *
 *     drawRect = This defines the rectangular region into which the
 *                oval is to be drawn.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XDrawFilled()  [libX.a]
 *   XDrawTiled()   [libX.a]
 *
 *************************************<->***********************************/

_XrFillOval (windowId, GC, drawRect)

            Window      windowId;
   register INT32       GC;
   register RECTANGLE * drawRect;

{
   register INT32 heightHalf;

   heightHalf = ((UINT16) drawRect->height >> 1);

   ovalList[0].x = drawRect->x + heightHalf;
   ovalList[0].y = drawRect->y;
   ovalList[1].x = drawRect->x + heightHalf;
   ovalList[1].y = drawRect->y;
   ovalList[2].x = drawRect->x + drawRect->width - heightHalf - 1;
   ovalList[2].y = drawRect->y;
   ovalList[3].x = drawRect->x + drawRect->width - heightHalf - 1;
   ovalList[3].y = drawRect->y;
   ovalList[4].x = drawRect->x + drawRect->width - 1;
   ovalList[4].y = drawRect->y + heightHalf;
   ovalList[5].x = drawRect->x + drawRect->width - heightHalf - 1;
   ovalList[5].y = drawRect->y + drawRect->height - 1;
   ovalList[6].x = drawRect->x + drawRect->width - heightHalf - 1;
   ovalList[6].y = drawRect->y + drawRect->height - 1;
   ovalList[7].x = drawRect->x + heightHalf;
   ovalList[7].y = drawRect->y + drawRect->height - 1;
   ovalList[8].x = drawRect->x + heightHalf;
   ovalList[8].y = drawRect->y + drawRect->height - 1;
   ovalList[9].x = drawRect->x;
   ovalList[9].y = drawRect->y + heightHalf;
   ovalList[10].x = drawRect->x + heightHalf;
   ovalList[10].y = drawRect->y;

   if (xr_GCList[GC][XrFILLSTYLEVAL] == Solid)
      XDrawFilled (windowId, ovalList, 11, xr_GCList[GC][XrFOREGROUNDVAL],
                   xr_GCList[GC][XrALUVAL], AllPlanes);
   else if (xr_GCList[GC][XrFILLSTYLEVAL] == Tiled)
      XDrawTiled (windowId, ovalList, 11, xr_GCList[GC][XrTILEVAL],
                  xr_GCList[GC][XrALUVAL], AllPlanes);
}


