{Dynamic lists implementation.                                               }
{v3.0.3 (c) 17.05.2000 by Flying/Digital Reality                             }
Unit List;

Interface

Type
{ࠪ ꥪ}
  PObject = ^TObject;
  TObject = object
    Constructor Init;
    Destructor Done;
  end;

  PListItem = ^TListItem; {⨯   ᯨ᪠}
  TListItem = record
    Item:PObject;         {㪠⥫  }
    Next:PListItem;       {㪠⥫  ᫥騩   nil}
    Prev:PListItem;       {㪠⥫  ।騩   nil}
  end;

  PList = ^TList;         {⨯  ᯨ᪠}
  TList = object
    List_:PListItem;     {㪠⥫  砫 ᯨ᪠}
    CurItem:PListItem;   {㪠⥫  ⥪騩  ᯨ᪠}
    QItems:word;         {⢮ ⮢ ᯨ᪠}
    Sorted:boolean;      {TRUE, ᫨ ᯨ᮪   ஢}
    Duplicates:boolean;  {TRUE, ᫨ ᪠ 騥 }
    Constructor Init;
    Destructor Done;
    Function  Insert(Item:Pointer):word;
              {⠢  Item  ⥪  ᯨ᪠}
              {頥  ⠢   ᯨ᪥}
    Procedure InsertAt(Item:Pointer;Num:word);
              {⠢  Item   ᯨ᪠ Num}
              {᫨ Num 室   0..QItems, }
              {Item   ᯨ᪠}
    Procedure Append(Item:Pointer);
              { Item   ᯨ᪠}
    Procedure Delete;
              { ⥪騩  ᯨ᪠}
    Procedure DeleteItem(Item:Pointer);
              {    祭  ᯨ᪠}
    Procedure DeleteAt(Num:word);
              {  ᯨ᪠  ஬ Num}
    Procedure ClearList;
              {頥 ᯨ᮪, 㤠  }
    Function  GetSize:word;
              {頥 ࠧ ᯨ᪠}
    Procedure SetCurrent(Num:word);
              {⠭ ⥪騬  ᯨ᪠  ஬ Num}
              {᫨ Num 室   0..QItems, ⠭}
              {⥪騬 ᫥  ᯨ᪠}
    Function  GetCurrent:word;
              {頥  ⥪饣  ᯨ᪠}
    Function  GetItem:Pointer;
              {頥 ⥪騩  ᯨ᪠}
    Function  GetItemAt(Num:word):Pointer;
              {頥  ᯨ᪠  ஬ Num}
              {᫨ Num 室   0..QItems, 頥}
              {᫥  ᯨ᪠}
    Function  GetNext:Pointer;
              {頥 ᫥騩  ᯨ᪠  ⠭}
              {㪠⥫  . ᫨ ᫥饣   - }
              {頥 nil}
    Function  GetPrev:Pointer;
              {頥 ।騩  ᯨ᪠  ⠭}
              {㪠⥫  . ᫨ ।饣   - }
              {頥 nil}
    Procedure DisposeItem(Item:Pointer);virtual;
              { 楤    ꥪ-᫥ }
              {⥬, ⮡ ४⭮ ᢮ .}
    Function  IndexOf(Item:pointer):integer;virtual;
              {㭪 頥    ᯨ᪥  -1, ᫨}
              {  }
    Function  KeyOf(Item:pointer):pointer;virtual;
              {㭪 頥 㪠⥫  祢  }
              {. ᯮ  ஢. ⮤ }
              {४뢠  ꥪ-᫥, ᫨ 室}
              {஢  -  ࠭  ᯨ᪥ ꥪ.}
    Function  Search(Key:pointer;var Index:integer):boolean;virtual;
              {㭪 믮     祬  ᯨ᪥.}
              {頥 TRUE, ᫨ ꥪ  (Index 㤥 ࠢ }
              {   ᯨ᪥). ᫨ ꥪ   - }
              {㭪 頥 FALSE  Index, ࠢ , 㤠}
              {室  ꥪ   祬.}
    Procedure SortList;
              { ᯨ᮪.  ࠢ 2- ⮢ ᯮ}
              {⮤ CompareItems}
    Function  CompareItems(Item1,Item2:Pointer):shortint;virtual;
              {⮤ ४뢠  ꥪ-᫥  ࠢ}
              {2- ⮢ ᯨ᪠. 頥 ᫥騥 祭:}
              { -1 = Item1<Item2 }
              {  0 = Item1=Item2 }
              {  1 = Item1>Item2 }
  end;

Implementation
{============================================================================}
{  ⮤ ꥪ TObject                                         }
{============================================================================}
Constructor TObject.Init;
begin
end;

Destructor TObject.Done;
begin
end;

{============================================================================}
{  ⮤ ꥪ TList                                           }
{============================================================================}
Constructor TList.Init;
begin
  List_:=nil;
  CurItem:=List_;
  QItems:=0;
  Sorted:=false;
  Duplicates:=false;
end;

Destructor TList.Done;
var
  i:integer;
  p,p1:PListItem;
begin
  p:=List_;
  if p=nil then
    exit;
  repeat
    p1:=p^.Next;
    DisposeItem(p^.Item);
    Dispose(p);
    p:=p1;
  until p=nil;
end;

Function TList.Insert(Item:Pointer):word;
var
  i:integer;
begin
  if not Sorted then
    begin
      InsertAt(Item,QItems);
      Insert:=QItems;
    end
  else
    if not Search(KeyOf(Item),i) or Duplicates then
    begin
      InsertAt(Item,i);
      Insert:=i;
    end;
end;

Procedure TList.InsertAt(Item:Pointer;Num:word);
var
  Ptr:PListItem;
  i:word;
begin
  Ptr:=List_;
  if Ptr<>nil then
  begin
    for i:=0 to Num do
    begin
      if (i=Num) or (Ptr^.Next=nil) then
        break;
      Ptr:=Ptr^.Next;
    end;
  end;
  New(CurItem);
  CurItem^.Item:=Item;
  if Ptr<>nil then
    CurItem^.Next:=Ptr^.Next
  else
    CurItem^.Next:=nil;
  CurItem^.Prev:=Ptr;
  if Ptr<>nil then
    Ptr^.Next:=CurItem;
  if CurItem^.Prev=nil then
    List_:=CurItem;
  inc(QItems);
end;

Procedure TList.Append(Item:Pointer);
var
  Ptr:PListItem;
begin
  Ptr:=List_;
  if Ptr=nil then
  begin
    Insert(Item);
    exit;
  end;
  repeat
    Ptr:=Ptr^.Next;
  until Ptr^.Next=nil;
  New(CurItem);
  CurItem^.Item:=Item;
  if Ptr<>nil then
    CurItem^.Next:=Ptr^.Next
  else
    CurItem^.Next:=nil;
  CurItem^.Prev:=Ptr;
  if Ptr<>nil then
    Ptr^.Next:=CurItem;
  if CurItem^.Prev=nil then
    List_:=CurItem;
  inc(QItems);
end;

Procedure TList.Delete;
var
  Ptr:PListItem;
begin
  if CurItem=nil then
    exit;
  Ptr:=CurItem^.Next;
  if CurItem^.Prev<>nil then
    CurItem^.Prev^.Next:=CurItem^.Next;
  if CurItem^.Next<>nil then
    CurItem^.Next^.Prev:=CurItem^.Prev;
  if CurItem^.Prev=nil then
    List_:=CurItem^.Next;
  DisposeItem(CurItem^.Item);
  Dispose(CurItem);
  CurItem:=Ptr;
  dec(QItems);
  if QItems=0 then
    List_:=nil;
end;

Procedure TList.DeleteItem(Item:Pointer);
var
  i:integer;
begin
  while Search(KeyOf(Item),i) do
    DeleteAt(i);
end;

Procedure TList.DeleteAt(Num:word);
var
  Ptr:PListItem;
  i:word;
begin
  Ptr:=List_;
  if (Ptr=nil) or (QItems<Num) then
    exit;
  for i:=0 to Num do
  begin
    if i=Num then
      break;
    if Ptr^.Next=nil then
      break;
    Ptr:=Ptr^.Next;
  end;
  if Ptr=nil then
    exit;
  if Ptr=CurItem then
    begin
      CurItem:=Ptr^.Next;
      if Ptr^.Prev<>nil then
        Ptr^.Prev^.Next:=Ptr^.Next;
      if Ptr^.Next<>nil then
        Ptr^.Next^.Prev:=Ptr^.Prev;
      if CurItem=nil then
        CurItem:=Ptr^.Prev;
      if (CurItem<>nil) and (CurItem^.Prev=nil) then
        List_:=CurItem;
      DisposeItem(Ptr^.Item);
      Dispose(Ptr);
      dec(QItems);
    end
  else
    begin
      if Ptr^.Prev<>nil then
        Ptr^.Prev^.Next:=Ptr^.Next;
      if Ptr^.Next<>nil then
        Ptr^.Next^.Prev:=Ptr^.Prev;
      if Ptr^.Prev=nil then
        List_:=Ptr^.Next;
      DisposeItem(Ptr^.Item);
      Dispose(Ptr);
      dec(QItems);
    end;
  if QItems=0 then
    List_:=nil;
end;

Procedure TList.ClearList;
var
  i:integer;
  p,p1:PListItem;
begin
  p:=List_;
  if p=nil then
  begin
    List_:=nil;
    CurItem:=nil;
    QItems:=0;
    exit;
  end;
  repeat
    p1:=p^.Next;
    DisposeItem(p^.Item);
    Dispose(p);
    p:=p1;
  until p=nil;
  List_:=nil;
  CurItem:=nil;
  QItems:=0;
end;

Function TList.GetSize:word;
begin
  GetSize:=QItems;
end;

Procedure TList.SetCurrent(Num:word);
var
  Ptr:PListItem;
  i:word;
begin
  Ptr:=List_;
  if Ptr=nil then
  begin
    CurItem:=Ptr;
    exit;
  end;
  for i:=0 to Num do
  begin
    if (i=Num) or (Ptr^.Next=nil) then
      break;
    Ptr:=Ptr^.Next;
  end;
  CurItem:=Ptr;
end;

Function TList.GetCurrent:word;
var
  Ptr:PListItem;
  i:word;
begin
  Ptr:=List_;
  if Ptr=nil then
  begin
    GetCurrent:=0;
    exit;
  end;
  i:=0;
  while Ptr<>CurItem do
  begin
    Ptr:=Ptr^.Next;
    inc(i);
  end;
  GetCurrent:=i;
end;

Function TList.GetItem:Pointer;
begin
  if CurItem=nil then
    GetItem:=nil
  else
    GetItem:=CurItem^.Item;
end;

Function TList.GetItemAt(Num:word):Pointer;
var
  Ptr:PListItem;
  i:word;
begin
  Ptr:=List_;
  if Ptr=nil then
  begin
    CurItem:=Ptr;
    GetItemAt:=nil;
    exit;
  end;
  for i:=0 to Num do
  begin
    if (i=Num) or (Ptr^.Next=nil) then
      break;
    Ptr:=Ptr^.Next;
  end;
  GetItemAt:=Ptr^.Item;
end;

Function TList.GetNext:Pointer;
begin
  if CurItem=nil then
  begin
    GetNext:=nil;
    exit;
  end;
  if CurItem^.Next=nil then
  begin
    GetNext:=nil;
    exit;
  end;
  GetNext:=CurItem^.Next^.Item;
  if CurItem^.Next<>nil then
    CurItem:=CurItem^.Next;
end;

Function TList.GetPrev:Pointer;
begin
  if CurItem=nil then
  begin
    GetPrev:=nil;
    exit;
  end;
  if CurItem^.Prev=nil then
  begin
    GetPrev:=nil;
    exit;
  end;
  GetPrev:=CurItem^.Prev^.Item;
  if CurItem^.Prev<>nil then
    CurItem:=CurItem^.Prev;
end;

Procedure TList.DisposeItem(Item:Pointer);
begin
  Dispose(Item);
end;

Function TList.IndexOf(Item:pointer):integer;
var
  i,j:integer;
  ciSave:PListItem;
  _Item:pointer;
begin
  IndexOf:=-1;
  if Search(KeyOf(Item),i) then
  begin
    if Duplicates then
    begin
      ciSave:=CurItem;
      SetCurrent(i);
      _Item:=GetItem;
      for j:=i to GetSize do
      begin
        if _Item=Item then
          i:=j;
        _Item:=GetNext;
      end;
      CurItem:=ciSave;
    end;
    if i<QItems then
      IndexOf:=i;
  end;
end;

Function TList.KeyOf(Item:pointer):pointer;
begin
  KeyOf:=Item;
end;

Function TList.Search(Key:pointer;var Index:integer):boolean;
var
  L,H,I,C:integer;
begin
  Search:=false;
  L:=0;
  H:=QItems-1;
  while L<=H do
  begin
    I:=(L+H) shr 1;
    C:=CompareItems(KeyOf(GetItemAt(i)),Key);
    if C<0 then
      L:=I+1
    else
      begin
        H:=I-1;
        if C=0 then
        begin
          Search:=true;
          if not Duplicates then
            L:=I;
        end;
      end;
  end;
  Index:=L;
end;

Procedure TList.SortList;
var
  Ptr:PListItem;
  i,j:word;
  MinItem:PListItem;
  PtrSave:PListItem;
  TempPtr:PObject;
begin
  Ptr:=List_;
  if (Ptr=nil) or (Ptr^.Next=nil) then
    exit;
  for i:=1 to QItems-1 do
  begin
    MinItem:=Ptr;
    Ptr:=Ptr^.Next;
    PtrSave:=Ptr;
    for j:=i+1 to QItems do
    begin
      if CompareItems(MinItem^.Item,Ptr^.Item)=-1 then
        MinItem:=Ptr;
      TempPtr:=MinItem^.Item;
      MinItem^.Item:=Ptr^.Item;
      Ptr^.Item:=TempPtr;
      Ptr:=Ptr^.Next;
    end;
    Ptr:=PtrSave;
  end;
end;

Function TList.CompareItems(Item1,Item2:Pointer):shortint;
begin
  CompareItems:=0;
end;

END.
