/* Defines */
#define PROGRAM_VERSION "0.5"

/* Declaration */
int country_number[] = { 74, 69, 80, 68, 70, 73, 83, 72, 75, 88, 0 };
char *country_code[] = { "JPN", "USA", "EUR", "NOE", "NOE", "ITA", "SPA", "HOL", "KOR", "EUU", "???" };
char *maker_letter[] = { "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "0G", "0H", "0J", "0L", "0N", "0P", "10", "12", "13", "15", "16", "17", "18", "19", "1A", "1C", "1D", "1E", "1F", "1G", "1J", "1P", "1Q", "20", "21", "22", "23", "25", "26", "27", "28", "29", "2A", "2C", "2D", "2E", "2F", "2G", "2H", "2J", "2K", "2L", "2M", "2N", "2Q", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "44", "46", "47", "49", "4B", "4C", "4D", "4F", "4G", "4J", "4K", "4Q", "4S", "4U", "4X", "4Y", "4Z", "50", "51", "52", "53", "54", "55", "56", "58", "5A", "5B", "5C", "5D", "5F", "5G", "5H", "5K", "5L", "5M", "5N", "5P", "5Q", "5S", "5T", "5W", "5X", "5Z", "60", "61", "62", "64", "67", "69", "6B", "6E", "6F", "6G", "6H", "6J", "6L", "6M", "6Q", "6S", "6U", "6V", "6W", "6X", "6Y", "6Z", "70", "71", "72", "73", "75", "78", "79", "7A", "7C", "7D", "7F", "7G", "7H", "7J", "7K", "7L", "7M", "7N", "7Q", "7T", "7U", "7W", "80", "81", "82", "83", "84", "86", "87", "88", "8B", "8C", "8E", "8F", "8G", "8J", "8N", "8P", "90", "91", "92", "93", "95", "96", "97", "99", "9A", "9B", "9C", "9F", "9G", "9H", "9J", "9L", "9N", "9P", "9Q", "A0", "A1", "A4", "A5", "A6", "A7", "A9", "AA", "AC", "AD", "AF", "AG", "AH", "AJ", "AK", "AL", "AP", "AQ", "B0", "B1", "B2", "B4", "B6", "B7", "B9", "BA", "BB", "BC", "BD", "BF", "BG", "BH", "BJ", "BL", "BN", "BP", "BQ", "C0", "C2", "C3", "C4", "C5", "C6", "C8", "CA", "CB", "CC", "CD", "CE", "CF", "CG", "CJ", "CK", "CL", "CM", "CP", "D0", "D1", "D2", "D3", "D4", "D6", "D7", "D8", "D9", "DA", "DB", "DD", "DE", "DF", "DG", "DH", "DL", "DN", "E0", "E1", "E2", "E3", "E4", "E5", "E7", "E8", "E9", "EA", "EB", "EC", "EE", "EG", "EH", "EJ", "EL", "EM", "EN", "F0", "F1", "F2", "F3", "F4", "F9", "FB", "FE", "G1", "G4", "G5", "G6", "G7", "G8", "G9", "GB", "GD", "IH", "\0" };
char *maker_name[]   = { "Nintendo", "Ajinomoto", "Imagineer-Zoom", "Gray Matter", "Zamuse", "Falcom", "Enix", "Capcom", "Hot B Co.", "Jaleco", "Coconuts Japan", "Coconuts Japan/G.X.Media", "Micronet", "Technos", "Mebio Software", "Shouei System", "Starfish", "Mitsui Fudosan/Dentsu", "Warashi Inc.", "Nowpro", "Game Village", "?", "Infocom", "Electronic Arts Japan", "Cobra Team", "Human/Field", "KOEI", "Hudson Soft", "S.C.P.", "Yanoman", "Tecmo Products", "Japan Glary Business", "Forum/OpenSystem", "Virgin Games ", "SMDE", "Daikokudenki", "Creatures Inc.", "TDK Deep Impresion", "Destination Software", "Sunsoft/Tokai Engineering", "POW ", "Micro World", "San-X", "Enix", "Loriciel/Electro Brain", "Kemco Japan", "Seta", "Culture Brain", "Palsoft", "Visit Co.,Ltd.", "Intec", "System Sacom", "Poppo", "Ubisoft Japan", "Media Works", "NEC InterChannel", "Tam", "Jordan", "Smilesoft", "Mediakite", "Viacom", "Carrozzeria", "Dynamic", "NOT A COMPANY!", "Magifact", "Hect", "Codemasters", "Taito/GAGA Communications", "Laguna", "Event/Taito", "Arcade Zone Ltd", "Entertainment International/Empire Software", "Loriciel", "Gremlin Graphics", "K.Amusement Leasing Co.", "Seika Corp.", "Ubi Soft Entertainment", "Sunsoft US", "Life Fitness", "System 3", "Spectrum Holobyte", "IREM", "Raya Systems", "Renovation Products", "Malibu Games", "Eidos", "Playmates Interactive", "Fox Interactive", "Time Warner Interactive", "Disney Interactive", "Black Pearl", "Advanced Productions", "GT Interactive", "RARE", "Crave Entertainment", "Absolute Entertainment", "Acclaim", "Activision", "American Sammy", "Take 2 Interactive", "Hi Tech", "LJN LTD.", "Mattel", "Mindscape", "Romstar", "Taxan", "Midway", "American Softworks", "Majesco Sales Inc", "3DO", "Hasbro", "NewKidCo", "Telegames", "Metro3D", "Vatical Entertainment", "LEGO Media", "Xicat Interactive", "Cryo Interactive", "Red Storm Entertainment", "Microids", "Conspiracy/Swing", "Titus", "Virgin Interactive", "Maxis", "LucasArts Entertainment", "Ocean", "Electronic Arts", "Laser Beam",
                         "Elite Systems", "Electro Brain", "The Learning Company", "BBC", "Software 2000", "BAM! Entertainment", "Studio 3", "Classified Games", "TDK Mediactive", "DreamCatcher", "JoWood Produtions", "SEGA", "Wannado Edition", "LSP ", "ITE Media", "Infogrames", "Interplay", "JVC ", "Parker Brothers", "Sales Curve", "THQ", "Accolade", "Triffix Entertainment", "Microprose Software", "Universal Interactive", "Kemco", "Rage Software", "Encore", "Zoo", "BVM", "Simon & Schuster Interactive ", "Asmik Ace Entertainment Inc./AIA ", "Empire Interactive", "Jester Interactive", "Scholastic", "Ignition Entertainment", "Stadlbauer", "Misawa", "Teichiku", "Namco Ltd.", "LOZC", "KOEI", "Tokuma Shoten Intermedia", "Tsukuda Original", "DATAM-Polystar", "Bulletproof Software", "Vic Tokai Inc.", "Character Soft", "I'Max", "Saurus", "General Entertainment", "Success", "SEGA Japan", "Takara Amusement", "Chun Soft", "Video System", "BEC", "Varie", "Yonezawa/S'pal", "Kaneko", "Victor Interactive Software", "Nichibutsu/Nihon Bussan", "Tecmo", "Imagineer", "Nova ", "Den'Z", "Bottom Up", "TGL", "Hasbro Japan", "Marvelous Entertainment", "Keynet Inc.", "Hands-On Entertainment", "Telenet", "Hori", "Konami", "K.Amusement Leasing Co.", "Kawada", "Takara", "Technos Japan Corp.", "JVC ", "Toei Animation", "Toho", "Namco", "Media Rings Corporation", "J-Wing", "Pioneer LDC", "KID", "Mediafactory", "Infogrames Hudson", "Kiratto. Ludic Inc", "Acclaim Japan", "ASCII", "Bandai", "Enix", "HAL Laboratory", "SNK", "Pony Canyon ", "Culture Brain", "Sunsoft", "Toshiba EMI", "Sony Imagesoft", "Sammy", "Magical", "Visco", "Compile", "MTO Inc.", "Sunrise Interactive", "Global A Entertainment", "Fuuki", "Taito", "Kemco", "Square", "Tokuma Shoten", "Data East", "Tonkin House", "Koei", "Konami/Ultra/Palcom", "NTVIC/VAP", "Use Co.,Ltd.", "Meldac", "Pony Canyon", "Angel", "Yumedia/Aroma Co., Ltd", "Boss", "Axela/Crea-Tech", "Sekaibunka-Sha, Sumire kobo", "Konami Computer Entertainment Osaka", "Enterbrain", "Taito/Disco", "Sofel", "Quest",
						 "Sigma", "Ask Kodansha", "Naxat", "Copya System", "Capcom Co., Ltd.", "Banpresto", "TOMY", "LJN Japan", "NCS", "Human Entertainment", "Altron", "Jaleco", "Gaps Inc.", "Digital Kids", "Elf", "Jaleco", "?", "Yutaka", "Varie", "T&ESoft", "Epoch", "Athena", "Asmik", "Natsume", "King Records", "Atlus", "Epic/Sony Records", "IGS ", "Chatnoir", "Right Stuff", "?", "Spike", "Konami Computer Entertainment Tokyo", "Alphadream Corporation", "A Wave", "Motown Software", "Left Field Entertainment", "Extreme Ent. Grp.", "TecMagik", "Cybersoft", "Psygnosis", "Davidson/Western Tech.", "PCCW Japan", "KiKi Co Ltd", "Open Sesame Inc", "Sims", "Broccoli", "Avex", "D3 Publisher", "Konami Computer Entertainment Japan", "Square-Enix", "Yojigen", "Unknown" };
char *save_types[]   = { "EEPROM_", "FLASH512_", "SRAM_", "FLASH_", "FLASH1M_" };

static unsigned long crc_table[256];

int arg_crc		= 0;
int arg_short		= 0;
int arg_save		= 0;

/* Structs */
typedef struct {
	unsigned long entrypoint;
	char nintendologo[157];
	char gametitle[13];
	char gamecode[5];
	char makercode[3];
	unsigned int fixedvalue;   /* must be 0x96 */
	unsigned int mainunitcode; /* 0x00 for current modles */
	unsigned int devicetype;   /* ??? */
	char lreservedarea[8];     /* should be zero filled */
	char version;
	int complement;
	char sreservedarea[3];     /* should be zero filled */
	int intro;
	unsigned long size;
	float mbits;
	unsigned long crc;
	char savetype[16];
} gba_header;

/* Proto types */
void usage(char * argv);
void gen_table(void);
unsigned long get_crc(FILE *);
int cmpsave(char *b);

