
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>
#include <linux/soundcard.h>
#include <sys/ioctl.h>
#include "au.h"
                     
int audio_fd;

int end_sound(void)
{
	if (audio_fd) close(audio_fd);
	audio_fd=0;
	return 0;
}


int start_sound(void)
{
	if (audio_fd) end_sound();
	if ((audio_fd=open("/dev/audio", O_RDWR)) == -1)
		return -1;

	ioctl(audio_fd, SNDCTL_DSP_NONBLOCK, NULL);

	return 0;
}

int play_sound(char *fname, int freq)
{
	int fd;
	char *buffer;
	struct stat fs;
	
	
	if ((fd=open(fname, O_RDONLY)) == -1)
		return -1; /* no such file */
	
	fstat(fd, &fs);
	
	buffer = mmap(NULL, fs.st_size, PROT_READ, MAP_PRIVATE, fd, 0);
	if (buffer == (void *)-1)
		return -2; /* can't mmap */

	ioctl(audio_fd, SNDCTL_DSP_RESET, NULL);
	ioctl(audio_fd, SNDCTL_DSP_SPEED, &freq);

	write(audio_fd, buffer, fs.st_size);
	close(fd);
	return 0;
}
