;---------------------------------- newGame -----------------------------------
 db 0 
ScoreTab:
 db 10,20,50,100,120,200
newGame:
 ld   a,startX
 ld   [xHmap],a
 ld   a,startZ
 ld   [zHmap],a
 ld   a,startXl
 ld   [xLmap],a
 ld   a,startZl
 ld   [zLmap],a
 xor  a
 ld   [gameOver],a
 ld   [scores],a
 ld   [scores+1],a
 ld   a,nLives
 ld   [lives],a
 ld   a,nPower
 ld   [power],a
 ld   a,nFuel
 ld   [fuel],a
 ld   a,ver1
 ld   [ver],a
 ld   a,fuelDelay
 ld   [fuelTemp],a
 call showPower
 call showLives
 call showScore
 call pre_fuel
 call showFuel
 ret
;
decPower: ;
 push af
 push bc
 push de
 push hl
 ld   b,a
 ld   a,[gameOver]
 or   a
 jr   nz,dpexit
 ld   a,[lives]
 ld   l,a
 ld   a,[power]
 sub  b
 jr   z,.lll
 jr   nc,nocarry
.lll
 ld   e,a
 inc  l
 dec  l
 jr   nz,minusLife
 ld   hl,gameOver
 inc  [hl]
 xor  a
 jr   nocarry
minusLife:
 ld   hl,lives
 dec  [hl]
 ld   a,nPower
nocarry:
 ld   [power],a
 call showPower
 call showLives
dpexit:
 pop  hl
 pop  de
 pop  bc
 pop  af
 ret


;
pre_fuel:
 ld   a,6
 ld   bc,$8891
 ld   de,$0f78
 call SetObjectFull
 inc  a
 ld   b,$98
 ld   e,$7a
 call SetObjectFull
 inc  a
 ld   bc,$8098
 ld   e,$7c
 call SetObjectFull
 inc  a
 ld   b,$90
 ld   e,$7e
 jp   SetObjectFull

showFuel:
 push af
 push bc
 push de
 push hl
 call .showFuel
 pop  hl
 pop  de
 pop  bc
 pop  af
 ret
;
.showFuel:
 ld   a,1
 ldio [$4f],a
 ld   a,[fuel]
 ld   e,a
 ld   a,nFuel
 sub  e
 ld   hl,$87c8
 jr   z,draw_fullFuel
 ld   b,a
.showFul:
 waitvblank
 ld   [hli],a
 ld   [hli],a
 dec  b
 jr   nz,.showFul
draw_fullFuel:
 ld   a,[fuel]
 or   a
 ret  z
 ld   b,a
 ld   c,%01111110
.showFul1:
 waitvblank
 ld   [hli],a
 ld   [hl],c
 inc  l
 dec  b
 jr   nz,.showFul1
 ret
;
showScore:
 push af
 push bc
 push de
 push hl
 ld   hl,scores
 ld   a,[hli]
 ld   h,[hl] 
 ld   l,a
 ld   bc,$8760
 ld   de,$0701
 call PrintHLasObjects
 pop  hl
 pop  de
 pop  bc
 pop  af
 ret
;
showLives:
 push af
 push bc
 push de
 push hl
 call .showL
 pop  hl
 pop  de
 pop  bc
 pop  af
 ret

.showL:
 ld   hl,$9a23
 ld   a,[lives]
 or   a
 jr   z,draw_emptyLives
.showLiv:
 push af
 ld   de,$8682
 call SetOn2Scr
 inc  hl
 pop  af
 dec  a
 jr   nz,.showLiv
draw_emptyLives
 ld   a,[lives]
 ld   e,a
 ld   a,nLives
 sub  e
 ret  z
 ld   de,$84e1
.showLiv1:
 push af
 call SetOn2Scr
 inc  hl
 pop  af
 dec  a
 jr   nz,.showLiv1
 ret
showPower:
 push af
 push bc
 push de
 push hl
 call .showP
 pop  hl
 pop  de
 pop  bc
 pop  af
 ret
.showP:
 ld   hl,$99c0
 ld   bc,32
 ld   a,[power]
 or   a
 jr   z,draw_emptyPower
.showPow:
 push af
 push hl
 ld   de,$8582
 call SetOn2Scr
 add  hl,bc
 ld   d,$8e
 call SetOn2Scr
 pop  hl
 inc  hl
 pop  af
 dec  a
 jr   nz,.showPow
draw_emptyPower
 ld   a,[power]
 ld   e,a
 ld   a,nPower
 sub  e
 ret  z
.showPow1:
 push af
 push hl
 ld   de,$8481
 call SetOn2Scr
 add  hl,bc
 call SetOn2Scr
 pop  hl
 inc  hl
 pop  af
 dec  a
 jr   nz,.showPow1
 ret