/*
 *      INSTALL.CMD - UPMLOGIN V1.01 - C.Langanke 1998
 *
 *      This program installs Telnet UPM Login (UPMLOGIN)
 *      onto your system.
 *
 *      "IBM TCP/IP for OS/2" ot the "Internet Access Kit" is required.
 */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info;
 Title     = Info;

 env          = 'OS2ENVIRONMENT';
 TRUE         = (1 = 1);
 FALSE        = (0 = 1);
 Redirection  = '> NUL 2>&1';
 '@ECHO OFF'

 /* OS/2 Fehlercodes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 GlobalVars = 'Title CmdName env TRUE FALSE Redirection ERROR.';
 SAY;

 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;

 /* default values */
 GlobalVars = GlobalVars 'Msg.';
 rc = ERROR.NO_ERROR;

 CallDir    = GetCallDir();
 TCPIPDrive = GetInstDrive( '\TCPIP\BIN');
 UPMDrive   = GetInstDrive( '\MUGLIB');
 ETCDir     = VALUE('ETC',, env);
 TargetDir  = TCPIPDrive'\TCPIP\BIN';

 SyslevelTitleId = 2;
 SyslevelTitle   = '';

 DO UNTIL (TRUE)

    /* search TCPIP install drive */
    IF (TCPIPDrive = '') THEN
    DO
       'CLS';
       SAY;
       SAY Title;
       SAY;
       SAY 'Error: TCP/IP installation not found.';
       SAY;
       SAY 'This package requires one of the following packages being installed:'
       SAY;
       SAY ' - IBM TCP/IP for OS/2';
       SAY ' - Internet Access Kit for OS/2';
       rc = ERROR.PATH_NOT_FOUND;
       LEAVE;
    END;

    /* search UPM install drive */
    IF (UPMDrive = '') THEN
    DO
       'CLS';
       SAY;
       SAY Title;
       SAY;
       SAY 'Error: UPM installation not found.';
       SAY;
       SAY 'This package requires one of the following packages being installed:'
       SAY;
       SAY ' For OS/2 WARP 3:';
       SAY ' - Peer Client for OS/2';
       SAY;
       SAY ' For OS/2 WARP 4:';
       SAY ' - File and Print Client';
       SAY;
       SAY ' All OS/2 versions:';
       SAY ' - LAN/WARP Server Client for OS/2';
       rc = ERROR.PATH_NOT_FOUND;
       LEAVE;
    END;

    /* determine language */
    LanguageTag = VALUE('TESTTAG',,env);
    IF (LanguageTag = '') THEN
    DO
       CurrentCsd          = ReadSyslevelFile( TargetDir'\SYSLEVEL.TCP', '', CURRCSD);
       LanguageTag         = SUBSTR( CurrentCsd, 3, 1);
    END;
    Language            = TranslateLanguageTag( LanguageTag);
    LanguageMessageFile = TRANSLATE('tnl'Language'.msg');
    IF (\FileExist( LanguageMessageFile)) THEN
    DO
       LanguageTag         = '0';
       Language            = 'ENG';
       LanguageMessageFile = TRANSLATE('tnleng.msg');
    END;

    IF (\FileExist( LanguageMessageFile)) THEN
    DO
       SAY CmdName': Error: Messagefile' LanguageMessageFile ' not found.';
       rc = ERROR.FILE_NOT_FOUND;
       LEAVE;
    END;
 
    DO
       IF (FileExist( LanguageMessageFile)) THEN
          SyslevelTitle = GetMessage( SyslevelTitleId, LanguageMessageFile);
    END;
 
    /* read object title */
    MessageFileInfo = GetMessage(0, LanguageMessageFile);
    PARSE VAR MessageFileInfo . Objectstart;
    IF (DATATYPE( ObjectStart) = 'NUM') THEN
    DO
       Title                   = GetMessage( 1,                LanguageMessageFile);
       Msg.TitleFolder         = GetMessage( ObjectStart +  0, LanguageMessageFile);
       Msg.TitleViewLogFile    = GetMessage( ObjectStart +  1, LanguageMessageFile);
       Msg.TitleViewErrFile    = GetMessage( ObjectStart +  2, LanguageMessageFile);
       Msg.TitleEditWelcomeMsg = GetMessage( ObjectStart +  3, LanguageMessageFile);
       Msg.TitleEditLoginMsg   = GetMessage( ObjectStart +  4, LanguageMessageFile);
       Msg.TitleViewReadme     = GetMessage( ObjectStart +  5, LanguageMessageFile);
       Msg.TitleLocalLogon     = GetMessage( ObjectStart +  6, LanguageMessageFile);
       Msg.TitleLocalLogoff    = GetMessage( ObjectStart +  7, LanguageMessageFile);
       Msg.Installprompt       = GetMessage( ObjectStart +  8, LanguageMessageFile);
       Msg.Copy                = GetMessage( ObjectStart +  9, LanguageMessageFile);
       Msg.CopyFailed          = GetMessage( ObjectStart + 10, LanguageMessageFile);
       Msg.Error               = GetMessage( ObjectStart + 11, LanguageMessageFile);
       Msg.Ok                  = GetMessage( ObjectStart + 12, LanguageMessageFile);
       Msg.Backup              = GetMessage( ObjectStart + 13, LanguageMessageFile);
       Msg.Replacement         = GetMessage( ObjectStart + 14, LanguageMessageFile);
       Msg.MsgFile             = GetMessage( ObjectStart + 15, LanguageMessageFile);
       Msg.ReadmeFile          = GetMessage( ObjectStart + 16, LanguageMessageFile);
       Msg.LoginMsgFiles       = GetMessage( ObjectStart + 17, LanguageMessageFile);
       Msg.SyslevelFile        = GetMessage( ObjectStart + 18, LanguageMessageFile);
       Msg.UPMCSet             = GetMessage( ObjectStart + 19, LanguageMessageFile);
       Msg.CreateFolder        = GetMessage( ObjectStart + 20, LanguageMessageFile);
    END;

    'CLS';
    SAY;
    SAY Title;
    SAY;
    SAY;
 
    /* ask user */
    IF (\ProceedWith( Msg.Installprompt)) THEN
       LEAVE;

    /* configure UPM */
    'COPY' LanguageMessageFile CallDir'\TNLOGIN.MSG' Redirection;
    'CALL' CallDir'\TNLOGIN /CONFIGUPM'
    rcConfigure = rc;
    'DEL' CallDir'\TNLOGIN.MSG';
    IF (rcConfigure \= ERROR.NO_ERROR) THEN
       LEAVE;
 
    /* create backup of exe file */
    i = 1;
    DO WHILE (TRUE)
       BackupFile = 'tnlogin.'RIGHT(i ,3, '0');
       IF (\FileExist(TargetDir'\'BackupFile)) THEN
       DO
          rc = Copyfiles( 'tnlogin.exe',  TargetDir'\'BackupFile, Msg.Backup BackupFile);
          LEAVE;
       END;
       i = i + 1;
    END;

    /* install EXE file */
    rc = Copyfiles( 'tnlogin.exe',  TargetDir'\', Msg.Replacement);
    if (rc \= ERROR.NO_ERROR) THEN
       LEAVE;
 
    /* install message file */
    rc = Copyfiles( LanguageMessageFile,  TargetDir'\tnlogin.msg', Msg.MsgFile);
    IF (rc \= ERROR.NO_ERROR) THEN
       LEAVE;
 
    /* install Readme */
    rc = Copyfiles( 'readme',  ETCDir'\tnlogin.txt', Msg.ReadmeFile);
    if (rc \= ERROR.NO_ERROR) THEN
       LEAVE;
 
    /* install welcome and login message */
    IF (ETCDir \= '') THEN
    DO
      rc = Copyfiles( 'ETC\*',  ETCDir'\', Msg.LoginMsgFiles);
      if (rc \= ERROR.NO_ERROR) THEN
      LEAVE;
    END;
 
    /* install syslevel file */
    rc = Copyfiles( 'sl.tnl',  TargetDir'\syslevel.*', Msg.SyslevelFile);
    if (rc \= ERROR.NO_ERROR) THEN
       LEAVE;
 
    /* patch title and language tag */
    SetSyslevelInfo( TargetDir'\syslevel.tnl', LanguageTag, SyslevelTitle);

    /* setting extended character set */
    CALL CHAROUT, Msg.UPMCSet '... ';
    'CALL UPMCSET /X' Redirection
    IF (rc = ERROR.NO_ERROR) THEN
    DO
       SAY Msg.Ok;
    END;
    ELSE 
       SAY Msg.Error;

    /* create some WPS objects */
    CALL CHAROUT, Msg.CreateFolder '... ';
    FolderPos = '30 43 65 36';
    rc = SysCreateObject( 'WPFolder',  Msg.TitleFolder,         '<WP_DESKTOP>',       'CCVIEW=NO;ICONVIEWPOS='FolderPos';OBJECTID=<UPMLOGIN_FOLDER>;', 'U');
    rc = SysCreateObject( 'WPShadow',  'Dummy',                 '<UPMLOGIN_FOLDER>',  'SHADOWID=<UPM_ACCTS>;OBJECTID=<UPMLOGIN_UPM_ACCTS_SHADOW>;', 'U');
    rc = SysCreateObject( 'WPProgram', Msg.TitleLocalLogoff,    '<UPMLOGIN_FOLDER>',  'EXENAME=LOGOFF.EXE;PARAMETERS=/s;PROGTYPE=WINDOWABLEVIO;MINIMIZED=YES;OBJECTID=<UPMLOGIN_LOCAL_LOGOFF;', 'U');
    rc = SysCreateObject( 'WPProgram', Msg.TitleLocalLogon,     '<UPMLOGIN_FOLDER>',  'EXENAME=LOGON.EXE;PARAMETERS=/L;PROGTYPE=PM;OBJECTID=<UPMLOGIN_LOCAL_LOGON;', 'U');
    rc = SysCreateObject( 'WPProgram', Msg.TitleViewLogFile,    '<UPMLOGIN_FOLDER>',  'EXENAME=E.EXE;PARAMETERS='ETCDir'\tnlogin.log;PROGTYPE=PM;OBJECTID=<UPMLOGIN_VIEW_LOGIN_LOG>;', 'U');
    rc = SysCreateObject( 'WPProgram', Msg.TitleViewErrFile,    '<UPMLOGIN_FOLDER>',  'EXENAME=E.EXE;PARAMETERS='ETCDir'\tnlogin.err;PROGTYPE=PM;OBJECTID=<UPMLOGIN_VIEW_ERROR_LOG>;', 'U');
    rc = SysCreateObject( 'WPProgram', Msg.TitleEditWelcomeMsg, '<UPMLOGIN_FOLDER>',  'EXENAME=E.EXE;PARAMETERS='ETCDir'\issue;PROGTYPE=PM;OBJECTID=<UPMLOGIN_EDIT_ISSUE>;', 'U');
    rc = SysCreateObject( 'WPProgram', Msg.TitleEditLoginMsg,   '<UPMLOGIN_FOLDER>',  'EXENAME=E.EXE;PARAMETERS='ETCDir'\motd;PROGTYPE=PM;OBJECTID=<UPMLOGIN_EDIT_MOTD>;', 'U');
    rc = SysCreateObject( 'WPProgram', Msg.TitleViewReadme,     '<UPMLOGIN_FOLDER>',  'EXENAME=E.EXE;PARAMETERS='ETCDir'\tnlogin.txt;PROGTYPE=PM;OBJECTID=<UPMLOGIN_VIEW_README>;', 'U');
    rc = SysOpenObject( '<UPMLOGIN_FOLDER>', 'ICON', TRUE);
    rc = SysOpenObject( '<UPMLOGIN_FOLDER>', 'ICON', TRUE);
    SAY Msg.Ok;
 
 END;
 
 SAY;
 EXIT(rc);

/* ------------------------------------------------------------------------- */
HALT:
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 PARSE SOURCE . . ThisFile

 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 rc = LINEOUT(Thisfile);

 RETURN('');

/* ------------------------------------------------------------------------- */
ProceedWith: PROCEDURE
 PARSE ARG Prompt

 ResponseKeys  = SysGetMessage(0);
 Yes           = WORD(ResponseKeys, 1);
 No            = WORD(ResponseKeys, 2);
 ch            = ' ';
 ValidResponse = Yes||No;

 SAY;
 CALL CHAROUT ,Prompt '('Yes'/'No') '
 DO WHILE (POS(ch, ValidResponse) = 0)
    ch = SysGetKey('NOECHO');
    ch = TRANSLATE(ch);
    IF (POS(ch, ValidResponse) = 0) THEN BEEP(800, 200);
 END;
 SAY;
 SAY;
 RETURN(ch = Yes);

/* ------------------------------------------------------------------------- */
GetInstDrive: PROCEDURE EXPOSE env
 ARG DirName, EnvVarName

 /* Default: OS2 directory */
 IF (DirName = '') THEN DirName = '\OS2';

 /* Default: PATH  */
 IF (EnvVarName = '') THEN EnvVarName = 'PATH';

 /* get value */
 PathValue = TRANSLATE(VALUE(EnvVarName,,env));

 /* search entry and return drive */
 DirName = ':'DirName';';
 EntryPos = POS(DirName, PathValue) - 1;
 IF (EntryPos = -1) THEN
    RETURN('');
 InstDrive = SUBSTR(PathValue, EntryPos, 2);
 RETURN(InstDrive);

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ------------------------------------------------------------------------- */
ReadSyslevelFile: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG File, ForceCompId, Request

 /* default values */
 result = '';
 Request = TRANSLATE(Request);

 /* valid tags */
 Tag.0      = 8;
 /* ------------------------------ */
 Tag.1      = 'SYSID';
 Tag.1.Exec = 'result = sysid';
 /* ------------------------------ */
 Tag.2      = 'EDITION';
 Tag.2.Exec = 'result = edition';
 /* ------------------------------ */
 Tag.3      = 'VERSION';
 Tag.3.Exec = 'result = version||modify';
 /* ------------------------------ */
 Tag.4      = 'MODIFY';
 Tag.4.Exec = 'result = modify';
 /* ------------------------------ */
 Tag.5      = 'CURRCSD';
 Tag.5.Exec = 'result = currCsd';
 /* ------------------------------ */
 Tag.6      = 'PREVCSD';
 Tag.6.Exec = 'result = prevCsd';
 /* ------------------------------ */
 Tag.7      = 'ID';
 Tag.7.Exec = 'result = compId';
 /* ------------------------------ */
 Tag.8      = 'NAME';
 Tag.8.Exec = 'result = sysname';

 /* read header */
 header        = C2D(CHARIN(File,,2));
 sig           =     CHARIN(File,,8);
 DateJulian    = C2D(CHARIN(File,,5));
 Version       = C2D(CHARIN(File,,2));
 reserved      =     CHARIN(File,,16);
 offset        = C2D(REVERSE(CHARIN(File,,4))) + 1;

 /* is signature valid */
 IF (sig \= 'SYSLEVEL') THEN
    RETURN('');

 /* read table */
 sysid          = C2D(REVERSE(CHARIN(File,offset, 2)));
 edition        = C2D(CHARIN(File,,1));
 version        = D2X(C2D(CHARIN(File,,1)));
 modify         = C2D(CHARIN(File,,1));
 DateValue      = CHARIN(File,,2);

 currCsd        = CHARIN(File,,8);
 prevCsd        = CHARIN(File,,8);
 sysName        = CHARIN(File,,80);
 compId         = CHARIN(File,,9); /* ignore the rest */

 /* check comp id, if given */
 IF (ForceCompId \= '') THEN
    IF (ForceCompId  \= compId) THEN
       RETURN('');

 /* transform version */
 version = LEFT(version,1)'.'SUBSTR(version,2)

 /* get result */
 IF (Request \= '') THEN
 DO i = 1 TO Tag.0
    IF (POS(Request, Tag.i) = 1) THEN
    DO
       INTERPRET(Tag.i.Exec);
    END;
 END;

 IF (Result = '') THEN
    result = sysid edition version modify currCsd prevCsd compId sysname;

 /* close file */
 rc = STREAM(File, 'C', 'CLOSE');

 RETURN(result);

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));
     
/* ========================================================================= */
SetSyslevelInfo: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG File, NewId, NewTitle

 /* read header */
 header        = C2D(CHARIN(File,,2));
 sig           =     CHARIN(File,,8);
 DateJulian    = C2D(CHARIN(File,,5));
 Version       = C2D(CHARIN(File,,2));
 reserved      =     CHARIN(File,,16);
 offset        = C2D(REVERSE(CHARIN(File,,4))) + 1;

 /* is signature valid */
 IF (sig \= 'SYSLEVEL') THEN
    RETURN('');

 /* determine data offsets */
 sysidOffs      = offset;
 editionOffs    = offset + 2;
 versionOffs    = offset + 3;
 modifyOffs     = offset + 4;
 DateValueOffs  = offset + 5;

 currCsdOffs    = offset +  7;
 prevCsdOffs    = offset + 15;
 sysNameOffs    = offset + 23;
 compIdOffs     = offset + 103;

 /* read in CSD level tags */
 CurrLevel = CHARIN(File, currCsdOffs, 8);
 PrevLevel = CHARIN(File, prevCsdOffs, 8);

 Id1 = SUBSTR(CurrLevel, 1, 3);
 Id2 = SUBSTR(PrevLevel, 1, 3);
 CurrId = RIGHT(Id1, 1);

 IF ((Id1 \= Id2) | (POS(CurrId, '0CDFGHIJLNPSUW') = 0)) THEN
    RETURN('');
 ELSE
 DO
    /* patch in new id and cose file */
    rc = CHAROUT(File, NewId, currCsdOffs + 2);
    rc = CHAROUT(File, NewId, prevCsdOffs + 2);
    IF (NewTitle \= '') THEN
    DO
       NewTitle = STRIP(SUBSTR(NewTitle, 1, 79));  /* cut to max 79 chars */
       NewTitle = NewTitle'00'x;
       rc = CHAROUT(File, NewTitle, sysNameOffs);
    END;
    rc = LINEOUT(File);
 END;
 RETURN('');

/* ========================================================================= */
TranslateLanguageTag: PROCEDURE
 ARG SearchString

 /* special values in LanguageTag:                       */
 /* '#'    : don't know the correct value yet            */
 /* special values in LanguageZMsg:                      */
 /* '*'    : language tag is unique, no zero msg needed  */
 /* '?????': don't know the correct value yet            */
 LanguageTag   = '0     U   G       D       F      H           H           S     I     W      N      F       J     P        B      C      T       O      0      0        #      #     #';
 LanguageAbbr  = 'ENG   ENG DEU     DAN     FRA    NDL         KOR         ESP   ITA   SVE    NOR    FIN     JPN   PTG      PTB    FRC    TWN     POL    POL    HUN      HEB    ARA   CHT';
 LanguageZMsg  = 'YNARI *   *       *       *      JNAHN       ?????       *     *     *      *      *       *     *        *      *      *       *      TNAPI  xxxxx    *      *     *';
               /* us    uk  germany denmark france netherlands netherlands spain italy sweden norway finland japan protugal brazil canada taiwan  poland poland hungaria israel arab. china */
               /*                                                                                                                                 WARP4  WARP3                              */

 /* determine which list to search */
 SELECT
    WHEN (LENGTH(SearchString) = 1) THEN SearchPos = WORDPOS(SearchString, TRANSLATE(LanguageTag));
    WHEN (LENGTH(SearchString) = 3) THEN SearchPos = WORDPOS(SearchString, TRANSLATE(LanguageAbbr));
    OTHERWISE NOP;
 END;

 IF (SearchPos = 0) THEN
    /* use default language code,if language not known */
    SearchPos = 1;

 /* make second check for languages, that have not a unique language tag */
 IF (WORD(LanguageZMsg, SearchPos) \= '*') THEN
 DO
    /* read the zero message of the system and remove spaces*/
    ZeroMsg = LEFT(SPACE(SysGetMessage(0), 0), 5);

    /* check the language again */
    SearchPos = WORDPOS(ZeroMsg, LanguageZMsg);

    IF (SearchPos = 0) THEN
       /* use non existing language code,if language not known */
       SearchPos = 1;
 END;

 /* now determine result */
 SELECT
    WHEN (LENGTH(SearchString) = 1) THEN SearchResult = WORD(LanguageAbbr, SearchPos);
    WHEN (LENGTH(SearchString) = 3) THEN SearchResult = WORD(LanguageTag,  SearchPos);
    OTHERWISE;
 END;

 RETURN(SearchResult);

/* ========================================================================= */
Copyfiles: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG Source, Target, Description

 rc = ERROR.NO_ERROR;

 /* install EXE file */
 CALL CHAROUT, Msg.Copy Description '... ';
 'COPY' Source Target Redirection;
 IF (rc \= ERROR.NO_ERROR) THEN
    SAY CmdName': ' Msg.CopyFailed Description'.';
 ELSE
   SAY Msg.Ok;

 RETURN(rc);

/* ========================================================================= */
GetMessage: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG Id, File

 Message = SysGetMessage( Id, File);
 Message = LEFT( Message, LENGTH( Message) - 2);
 RETURN(Message);

